#ifndef __FIELDBUS_FUNCTIONS_H_
#define __FIELDBUS_FUNCTIONS_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* ============================================================================= */
/* Fieldbus spezific functions                                                   */
/* ============================================================================= */
/* Activate indication from a fieldbus protocol */
int32_t Fieldbus_ActivateIndications( PCHANNELINSTANCE ptChannel,
                                      uint16_t         usProtocollClass,
                                      uint16_t         usCommunicationClass,
                                      uint8_t*         pbHandleIndications);

/* Register the application to receive indications from the fieldbus protocol */
int32_t Fieldbus_RegisterApplication( PCHANNELINSTANCE ptChannel);

uint8_t Fieldbus_HandleIndications( PCHANNELINSTANCE ptChannel);


#ifdef __cplusplus
}
#endif

#endif /* __FIELDBUS_FUNCTIONS_H_ */